<?php

if (!extension_loaded('sodium')) { http_response_code(500); exit; }
foreach (['xdebug','uopz','runkit','xhprof'] as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }
$__ERR = base64_decode('__ERRMSG__');
$__DOMS = json_decode(base64_decode('__DOMAINS__'), true);
$__EXP  = (int)('__EXPIRES__');
$__AAD  = json_decode(base64_decode('__AAD__'), true);
$host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
if (is_array($__DOMS) && count($__DOMS)>0) {
    $ok=false; foreach ($__DOMS as $d){ $d=strtolower(trim($d)); if ($host===$d || ($d && substr($host,-strlen('.'.$d)) === '.'.$d)) { $ok=true; break; } }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}
if ($__EXP>0 && time()>$__EXP) { http_response_code(403); echo $__ERR; exit; }
$licUrl   = (string)($__AAD['lic_url'] ?? '');
$appId    = (string)($__AAD['lic_app'] ?? '');
$pubKeyB64= (string)($__AAD['lic_pub'] ?? '');
$cacheSec = (int)($__AAD['lic_cache'] ?? 3600);
$pubKey   = base64_decode($pubKeyB64);
$cacheFile = sys_get_temp_dir().'/._lic_'.sha1($licUrl.$appId.$host.($__AAD['build']??'')).'.json';
$needFetch = true; $data = null;
if (is_file($cacheFile)) {
    $st = @stat($cacheFile);
    if ($st && (time()-$st['mtime'] < $cacheSec)) {
        $json = @file_get_contents($cacheFile);
        if ($json) { $data = json_decode($json, true); $needFetch=false; }
    }
}
if ($needFetch && $licUrl) {
    $qs = http_build_query(['app'=>$appId,'host'=>$host,'build'=>$__AAD['build'] ?? '','time'=>time()]);
    $ctx = stream_context_create(['http'=>['timeout'=>4]]);
    $resp = @file_get_contents(rtrim($licUrl,'/').'/api/check?'.$qs, false, $ctx);
    if ($resp) { $data = json_decode($resp, true); if ($data) @file_put_contents($cacheFile, json_encode($data)); }
}
if (!$data || empty($data['ok'])) { http_response_code(403); echo $__ERR; exit; }
$token = base64_decode($data['token'] ?? ''); $sig = base64_decode($data['sig'] ?? '');
if (!$token || !$sig || !$pubKey || !sodium_crypto_sign_verify_detached($sig, $token, $pubKey)) { http_response_code(403); echo $__ERR; exit; }
$claims = json_decode($token, true);
if (!$claims || ($claims['host'] ?? '') !== $host) { http_response_code(403); echo $__ERR; exit; }
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf=''; $n=count($parts);
    for($i=0;$i<$n;$i++){
        $p=base64_decode($parts[$i]); $m=base64_decode($masks[$i]); $r=(int)$rot[$i]; $x='';
        for($j=0;$j<strlen($p);$j++){ $b=ord($p[$j]); $x.=chr(((($b>>$r)|(($b<<(8-$r))&0xFF))&0xFF)); }
        $buf.=($x^$m);
    } return $buf;
}
$__KEY   = deobf_key(json_decode('__KEY_PARTS__',true), json_decode('__KEY_MASKS__',true), json_decode('__KEY_ROT__',true));
$__NONCE = base64_decode('__NONCE__');
$__AAD_b64= base64_decode('__AAD__');
$__CT    = base64_decode('__CT__');
$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD_b64, $__NONCE, $__KEY);
if ($__PT===false){ http_response_code(500); exit; }
$__IS_WP = (int)('__IS_WP__'); if ($__IS_WP && !defined('ABSPATH') && !defined('WPINC')) { /* optional */ }
$__tmp = sys_get_temp_dir().'/._'.sha1('__BUILD__'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT); include $__tmp; @unlink($__tmp);
